package ru.yandex.direct.internaltools.tools.oneshot.launch.model;

import java.time.LocalDateTime;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;
import ru.yandex.direct.oneshot.core.model.OneshotLaunchValidationStatus;

public class OneshotLaunchInfo {
    @JsonProperty("Id запуска")
    private Long launchId;
    @JsonProperty("Имя класса ваншота")
    private String className;
    @JsonProperty("Создатель запроса")
    private String launchCreator;
    @JsonProperty("Параметры")
    @Enrich(InternalToolDetailKey.EXPANDER)
    private String params;
    @JsonProperty("Статус валидации входных данных")
    private OneshotLaunchValidationStatus validationStatus;
    @JsonProperty("Апрувер")
    private String approver;
    @JsonProperty("Заапрувленная ревизия")
    private String approvedRevision;
    @JsonProperty("Когда инициировали выполнение")
    private LocalDateTime launchRequestTime;
    @JsonProperty("Статусы потоков")
    private String oneshotFlowsState;
    @Enrich(InternalToolDetailKey.LOGVIEWER_LINK_NAME_REPLACE)
    @JsonProperty("Лог")
    private String logviewerLink;

    public Long getLaunchId() {
        return launchId;
    }

    public OneshotLaunchInfo withLaunchId(Long launchId) {
        this.launchId = launchId;
        return this;
    }

    public String getClassName() {
        return className;
    }

    public OneshotLaunchInfo withClassName(String className) {
        this.className = className;
        return this;
    }

    public String getLaunchCreator() {
        return launchCreator;
    }

    public OneshotLaunchInfo withLaunchCreator(String launchCreator) {
        this.launchCreator = launchCreator;
        return this;
    }

    public String getParams() {
        return params;
    }

    public OneshotLaunchInfo withParams(String params) {
        this.params = params;
        return this;
    }

    public OneshotLaunchValidationStatus getValidationStatus() {
        return validationStatus;
    }

    public OneshotLaunchInfo withValidationStatus(OneshotLaunchValidationStatus validationStatus) {
        this.validationStatus = validationStatus;
        return this;
    }

    public String getApprover() {
        return approver;
    }

    public OneshotLaunchInfo withApprover(String approver) {
        this.approver = approver;
        return this;
    }

    public String getApprovedRevision() {
        return approvedRevision;
    }

    public OneshotLaunchInfo withApprovedRevision(String approvedRevision) {
        this.approvedRevision = approvedRevision;
        return this;
    }

    public LocalDateTime getLaunchRequestTime() {
        return launchRequestTime;
    }

    public OneshotLaunchInfo withLaunchRequestTime(LocalDateTime launchRequestTime) {
        this.launchRequestTime = launchRequestTime;
        return this;
    }

    public String getOneshotFlowsState() {
        return oneshotFlowsState;
    }

    public OneshotLaunchInfo withOneshotFlowsState(String oneshotLaunchState) {
        this.oneshotFlowsState = oneshotLaunchState;
        return this;
    }

    public String getLogviewerLink() {
        return logviewerLink;
    }

    public OneshotLaunchInfo withLogviewerLink(String logviewerLink) {
        this.logviewerLink = logviewerLink;
        return this;
    }
}
