package ru.yandex.direct.internaltools.tools.oneshot.launchdata.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.direct.oneshot.core.model.LaunchStatus;

@ParametersAreNonnullByDefault
public enum LaunchDataAction {
    PAUSE("Пауза", LaunchStatus.PAUSE_REQUESTED),
    CANCEL("Отмена (без возможности перезапуска)", LaunchStatus.CANCELED),
    START("Запуск", LaunchStatus.READY);

    private String description;
    private LaunchStatus launchStatus;

    LaunchDataAction(String description, LaunchStatus launchStatus) {
        this.description = description;
        this.launchStatus = launchStatus;
    }

    @JsonValue
    public String getDescription() {
        return description;
    }


    public LaunchStatus getLaunchStatus() {
        return launchStatus;
    }

    @Override
    public String toString() {
        return getDescription();
    }
}
