package ru.yandex.direct.internaltools.tools.oneshot.launchdata.model;

import java.time.LocalDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;
import ru.yandex.direct.oneshot.core.model.LaunchStatus;

@ParametersAreNonnullByDefault
public class LaunchDataInfo {
    @JsonProperty("Id потока")
    private Long launchDataId;
    @JsonProperty("Id запуска")
    private Long launchId;
    @JsonProperty("Шард")
    private Integer shard;
    @JsonProperty("Статус")
    private LaunchStatus launchStatus;
    @JsonProperty("Начало")
    private LocalDateTime launchTime;
    @JsonProperty("Конец")
    private LocalDateTime finishTime;
    @JsonProperty("Время последней активности")
    private LocalDateTime lastActiveTime;
    @JsonProperty("Ревизии")
    private String launchedRevisions;
    @JsonProperty("Состояние")
    private String state;
    @JsonProperty("Лог")
    @Enrich(InternalToolDetailKey.LOGVIEWER_LINK_NAME_REPLACE)
    private String logviewerUrl;

    public String getLogviewerUrl() {
        return logviewerUrl;
    }

    public LaunchDataInfo(Long launchDataId, Long launchId, Integer shard, LocalDateTime launchTime,
                          LocalDateTime lastActiveTime,
                          String launchedRevisions, LaunchStatus launchStatus, String state, LocalDateTime finishTime,
                          String logviewerUrl) {
        this.launchDataId = launchDataId;
        this.launchId = launchId;
        this.shard = shard;
        this.launchTime = launchTime;
        this.lastActiveTime = lastActiveTime;
        this.launchedRevisions = launchedRevisions;
        this.launchStatus = launchStatus;
        this.state = state;
        this.finishTime = finishTime;
        this.logviewerUrl = logviewerUrl;
    }
}
