package ru.yandex.direct.internaltools.tools.oneshot.launchdata.model;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.NumericId;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class LaunchDataInput extends InternalToolParameter {
    @Input(label = "Идентификатор потока запуска", required = false)
    @NumericId
    private Long launchDataId;

    @Input(label = "Идентификатор запуска (действие применится ко всем потокам запуска, для которых действие применимо)", required = false)
    @NumericId
    private Long launchId;

    @Input(label = "Действие", required = false)
    private LaunchDataAction action;

    public Long getLaunchDataId() {
        return launchDataId;
    }

    public Long getLaunchId() {
        return launchId;
    }

    public void setLaunchId(Long launchId) {
        this.launchId = launchId;
    }

    public void setLaunchDataId(Long launchDataId) {
        this.launchDataId = launchDataId;
    }

    public LaunchDataAction getAction() {
        return action;
    }

    public void setAction(LaunchDataAction action) {
        this.action = action;
    }
}
