package ru.yandex.direct.internaltools.tools.oneshot.oneshot;

import java.util.ArrayList;
import java.util.List;

import com.google.common.collect.ImmutableSet;
import one.util.streamex.StreamEx;
import org.springframework.stereotype.Component;

import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.input.InternalToolInput;
import ru.yandex.direct.internaltools.core.input.InternalToolInputPreProcessor;
import ru.yandex.direct.internaltools.tools.oneshot.OneshotToolsUtil;
import ru.yandex.direct.oneshot.core.entity.oneshot.service.OneshotService;

import static ru.yandex.direct.internaltools.tools.oneshot.oneshot.OneshotsTool.SORTING_COMPARATOR;
import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

@Component
public class OneshotsSelectProvider implements InternalToolInputPreProcessor<String> {

    private static final String EMPTY_PLACEHOLDER = "";

    private final OneshotService oneshotService;

    public OneshotsSelectProvider(OneshotService oneshotService) {
        this.oneshotService = oneshotService;
    }

    @Override
    public <T extends InternalToolParameter> InternalToolInput.Builder<T, String> preSend(
            InternalToolInput.Builder<T, String> inputBuilder) {

        List<String> launchableClassNames = StreamEx.of(oneshotService.getLaunchableOneshots())
                .sorted(SORTING_COMPARATOR)
                .map(complexOneshot -> complexOneshot.getOneshot().getClassName())
                .map(OneshotToolsUtil::cutOneshotClass)
                .toList();

        List<String> displayedValues = new ArrayList<>();
        displayedValues.add(EMPTY_PLACEHOLDER);
        displayedValues.addAll(launchableClassNames);

        return inputBuilder.withAllowedValues(displayedValues)
                .addValidator(inSet(ImmutableSet.copyOf(launchableClassNames)))
                .withDefaultValue(null);
    }
}
