package ru.yandex.direct.internaltools.tools.oneshot.oneshot.model;

import java.time.LocalDateTime;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

public class OneshotInfo {
    @JsonProperty("Id")
    private long id;
    @JsonProperty("Имя класса")
    private String className;
    @JsonProperty("Апруверы")
    private List<String> approvers;
    @JsonProperty("Тикет")
    @Enrich(InternalToolDetailKey.STARTREK_ONESHOT_TICKET_LINK_REPLACE)
    private String ticket;
    @JsonProperty("Время создания")
    private LocalDateTime createTime;
    @JsonProperty("Многоразовый")
    @Enrich(InternalToolDetailKey.BOOLEAN_MARKS_REPLACE)
    private boolean multiLaunch;
    @JsonProperty("Шардированный")
    @Enrich(InternalToolDetailKey.BOOLEAN_MARKS_REPLACE)
    private boolean sharded;
    @JsonProperty("Безопасный")
    @Enrich(InternalToolDetailKey.BOOLEAN_MARKS_REPLACE)
    private boolean safe;
    @JsonProperty("Удаленный")
    @Enrich(InternalToolDetailKey.BOOLEAN_MARKS_REPLACE)
    private boolean deleted;
    @JsonProperty("Были запуски")
    @Enrich(InternalToolDetailKey.BOOLEAN_MARKS_REPLACE)
    private boolean hasLaunches;
    @JsonProperty("Код ваншота")
    @Enrich(InternalToolDetailKey.ARCADIA_LINK_NAME_REPLACE)
    private String sourceCode;

    public long getId() {
        return id;
    }

    public OneshotInfo withId(long id) {
        this.id = id;
        return this;
    }

    public String getClassName() {
        return className;
    }

    public OneshotInfo withClassName(String className) {
        this.className = className;
        return this;
    }

    public List<String> getApprovers() {
        return approvers;
    }

    public OneshotInfo withApprovers(List<String> approvers) {
        this.approvers = approvers;
        return this;
    }

    public String getTicket() {
        return ticket;
    }

    public OneshotInfo withTicket(String ticket) {
        this.ticket = ticket;
        return this;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public OneshotInfo withCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
        return this;
    }

    public boolean isMultiLaunch() {
        return multiLaunch;
    }

    public OneshotInfo withMultiLaunch(boolean multiLaunch) {
        this.multiLaunch = multiLaunch;
        return this;
    }

    public boolean isSharded() {
        return sharded;
    }

    public OneshotInfo withSharded(boolean sharded) {
        this.sharded = sharded;
        return this;
    }

    public boolean isSafe() {
        return safe;
    }

    public OneshotInfo withSafe(boolean safe) {
        this.safe = safe;
        return this;
    }

    public boolean isDeleted() {
        return deleted;
    }

    public OneshotInfo withDeleted(boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    public boolean isHasLaunches() {
        return hasLaunches;
    }

    public OneshotInfo withHasLaunches(boolean hasLaunches) {
        this.hasLaunches = hasLaunches;
        return this;
    }

    public String getSourceCode() {
        return sourceCode;
    }

    public OneshotInfo withSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
        return this;
    }
}
