package ru.yandex.direct.internaltools.tools.outdoor.model;


import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class OutdoorPlacementInternalNameUpdateParameter extends InternalToolParameter {

    @Input(label = "Идентифиактор площадки")
    private Long pageId;

    @Input(label = "Внутреннее название площадки", required = false)
    private String internalName;

    @Select
    @Input(label = "Действие")
    private Action action;

    public Long getPageId() {
        return pageId;
    }

    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public OutdoorPlacementInternalNameUpdateParameter withPageId(Long pageId) {
        this.pageId = pageId;
        return this;
    }

    public String getInternalName() {
        return internalName;
    }

    public void setInternalName(String internalName) {
        this.internalName = internalName;
    }

    public OutdoorPlacementInternalNameUpdateParameter withInternalName(String internalName) {
        this.internalName = internalName;
        return this;
    }

    public Action getAction() {
        return action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public OutdoorPlacementInternalNameUpdateParameter withAction(Action action) {
        this.action = action;
        return this;
    }

    public enum Action {
        ADD_OR_UPDATE("Добавить или обновить"),
        REMOVE("Удалить");

        private final String description;

        Action(String description) {
            this.description = description;
        }

        @JsonValue
        public String getDescription() {
            return description;
        }
    }

    @Override
    public String toString() {
        return "OutdoorPlacementInternalNameUpdateParameter{" +
                "pageId=" + pageId +
                ", internalName='" + internalName + '\'' +
                '}';
    }
}
