package ru.yandex.direct.internaltools.tools.performance;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class IntToolPerfFilter {

    @JsonProperty("perfFilterId")
    private Long perfFilterId;

    @JsonProperty("adGroupId")
    private Long adGroupId;

    @JsonProperty("Old conditions_json")
    private String oldConditionsJson;

    @JsonProperty("New conditions_json")
    private String newConditionsJson;

    public Long getPerfFilterId() {
        return perfFilterId;
    }

    public void setPerfFilterId(Long perfFilterId) {
        this.perfFilterId = perfFilterId;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }

    IntToolPerfFilter withPerfFilterId(Long perfFilterId) {
        this.perfFilterId = perfFilterId;
        return this;
    }

    IntToolPerfFilter withAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
        return this;
    }

    IntToolPerfFilter withOldConditionsJson(String oldConditionsJson) {
        this.oldConditionsJson = oldConditionsJson;
        return this;
    }

    IntToolPerfFilter withNewConditionsJson(String newConditionsJson) {
        this.newConditionsJson = newConditionsJson;
        return this;
    }
}
