package ru.yandex.direct.internaltools.tools.performance;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Number;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@JsonIgnoreProperties(ignoreUnknown = true)
public class PerfFilterParameters extends InternalToolParameter {

    @Text
    @Input(label = "Логин пользователя, у которого хотим изменить фильтр (по умолчанию логин оператора)",
            required = false)
    private String login;

    @Number
    @Input(label = "ID фильтра")
    private Long perfFilterId;

    @Number
    @Input(label = "ID группы")
    private Long adGroupId;

    @TextArea
    @Input(label = "Фильтр в формате json")
    private String conditionJson;

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public Long getPerfFilterId() {
        return perfFilterId;
    }

    public void setPerfFilterId(Long perfFilterId) {
        this.perfFilterId = perfFilterId;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }

    public String getConditionJson() {
        return conditionJson;
    }

    public void setConditionJson(String conditionJson) {
        this.conditionJson = conditionJson;
    }
}
