package ru.yandex.direct.internaltools.tools.pitags;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class PiTagsParameter extends InternalToolParameter {
    public enum Mode {REMOVE, ADD, REPLACE}


    @Input(label = "Тип тэга")
    @Select(choices = {"OrderTag", "TargetTag"})
    private String tagType;

    @Input(label = "Тэг")
    @Text
    private String tag;

    @Input(label = "ClientId", required = false)
    @Text
    private String clientIds;

    @Input(label = "Логины, через запятую", required = false)
    @Text
    private String logins;

    @Input(label = "ID кампаний, через запятую", required = false)
    @Text
    private String cids;

    @Input(label = "Id групп, через запятую", required = false)
    @Text
    private String pids;

    @Input(label = "Что делать")
    //@Select(choices = {"Добавить", "Удалить", "Заменить"})
    private Mode mode;

    public String getTag() {
        return tag;
    }

    public String getTagType() {
        return tagType;
    }

    public String getClientIds() {
        return clientIds;
    }

    public String getLogins() {
        return logins;
    }

    public String getCids() {
        return cids;
    }

    public String getPids() {
        return pids;
    }

    public Mode getMode() {
        return mode;
    }
}
