package ru.yandex.direct.internaltools.tools.ppcproperties;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.implementations.MassInternalToolWithoutParam;
import ru.yandex.direct.internaltools.tools.ppcproperties.container.PropertyInfo;

@Tool(
        name = "Список всех ppc_property Директа",
        label = "list_all_ppc_properties",
        description = "Список всех ppc_property, сохраненных в базе Директа, и их значений",
        consumes = InternalToolParameter.class,
        type = InternalToolType.REPORT
)
@Action(InternalToolAction.REFRESH)
@Category(InternalToolCategory.PROPERTIES)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER})
@ParametersAreNonnullByDefault
public class ListAllPropertiesTool extends MassInternalToolWithoutParam<PropertyInfo> {
    private final PpcPropertiesSupport propertiesSupport;

    @Autowired
    public ListAllPropertiesTool(PpcPropertiesSupport propertiesSupport) {
        this.propertiesSupport = propertiesSupport;
    }

    @Override
    protected List<PropertyInfo> getMassData() {
        return propertiesSupport.getAllProperties()
                .entrySet().stream()
                .map(e -> new PropertyInfo(e.getKey(), e.getValue()))
                .sorted(Comparator.comparing(PropertyInfo::getName))
                .collect(Collectors.toList());
    }
}
