package ru.yandex.direct.internaltools.tools.ppcproperties;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.db.PpcProperty;
import ru.yandex.direct.internaltools.core.BaseInternalTool;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Disclaimers;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolResult;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.tools.ppcproperties.container.PreprodUsagePctParameter;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.common.db.PpcPropertyNames.EXPORT_PREPROD_USAGE_PCT_PROP_NAME;
import static ru.yandex.direct.validation.constraint.NumberConstraints.inRange;

@Tool(
        name = "Доля запросов к статистике БК, отщепляемая в пре-прод",
        label = "manage_bs_preprod_stat_usage_pct",
        description = "Отображает и задает процент запросов к некоторым ручкам статистики БК, которые будут " +
                "направлены в пре-продакшн хосты БК. Выбор производится по остатку от деления ClientID (владельца " +
                "заказов, по которым запрашивается статистика) на 100. Отщепляются запросы с остатком меньшим " +
                "заданного здесь.",
        consumes = PreprodUsagePctParameter.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.SET)
@Category(InternalToolCategory.EXPERIMENT)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER})
@Disclaimers({"Препрод мастера отчетов может использовать хранилище без полного набора статистических данных. " +
        "Подробнее в https://st.yandex-team.ru/BSDEV-75948, включайте предпрод только по согласованию с командой " +
        "статистики https://staff.yandex-team.ru/departments/yandex_monetize_banner_5934/", "Значение доли должно " +
        "быть целым числом от 0 до 100"})
@ParametersAreNonnullByDefault
public class ManageBsPreprodStatUsagePctTool implements BaseInternalTool<PreprodUsagePctParameter> {

    private final PpcProperty<Integer> property;
    static final String TITLE = "Текущий процент: ";

    @Autowired
    public ManageBsPreprodStatUsagePctTool(PpcPropertiesSupport ppcPropertiesSupport) {
        this.property = ppcPropertiesSupport.get(EXPORT_PREPROD_USAGE_PCT_PROP_NAME);
    }

    @Override
    public ValidationResult<PreprodUsagePctParameter, Defect> validate(PreprodUsagePctParameter param) {
        ItemValidationBuilder<PreprodUsagePctParameter, Defect> vb = ItemValidationBuilder.of(param, Defect.class);
        vb.item(param.getPreprodUsagePct(), PreprodUsagePctParameter.PREPROD_USAGE_PCT)
                .check(inRange(0L, 100L), When.notNull());
        return vb.getResult();
    }

    @Override
    public InternalToolResult process(PreprodUsagePctParameter parameter) {
        if (parameter.getPreprodUsagePct() != null) {
            property.set(parameter.getPreprodUsagePct().intValue());
        }
        return processWithoutInput();
    }

    @Override
    public InternalToolResult processWithoutInput() {
        return new InternalToolResult().withMessage(TITLE + property.get());
    }
}
