package ru.yandex.direct.internaltools.tools.ppcproperties.container;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.ppcproperty.model.PpcPropertyEnum;
import ru.yandex.direct.internaltools.core.annotations.input.CheckBox;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

import static ru.yandex.direct.internaltools.tools.ppcproperties.container.NewTypedPropertyValue.VALUE_FIELD_NAME;

@ParametersAreNonnullByDefault
public class NewPropertyValue extends InternalToolParameter {
    @Input(label = "Имя проперти")
    private PpcPropertyEnum name;

    @Input(label = VALUE_FIELD_NAME, required = false)
    private String value;

    @Input(label = "Удалить?")
    @CheckBox(checked = false)
    private Boolean toRemove;

    public PpcPropertyEnum getName() {
        return name;
    }

    public void setName(PpcPropertyEnum name) {
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Boolean getToRemove() {
        return toRemove;
    }
}
