package ru.yandex.direct.internaltools.tools.ppcproperties.container;

import ru.yandex.direct.internaltools.core.annotations.input.CheckBox;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.tools.ppcproperties.preprocessors.TypedPropertyNamesPreprocessor;

public class NewTypedPropertyValue extends InternalToolParameter {
    public static final String VALUE_FIELD_NAME = "Новое значение";

    @Input(label = "Имя проперти", processors = TypedPropertyNamesPreprocessor.class)
    @Select(preprocessed = true)
    private String name;

    @Input(label = VALUE_FIELD_NAME, required = false)
    private String value;

    @Input(label = "Удалить?")
    @CheckBox(checked = false)
    private Boolean toRemove;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Boolean getToRemove() {
        return toRemove;
    }

    public void setToRemove(Boolean toRemove) {
        this.toRemove = toRemove;
    }
}
