package ru.yandex.direct.internaltools.tools.ppcproperties.container;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Number;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@ParametersAreNonnullByDefault
public class PreprodUsagePctParameter extends InternalToolParameter {
    public static final String PREPROD_USAGE_PCT = "Процент запросов, направляемых в пре-прод БК.";

    @Input(label = PREPROD_USAGE_PCT, required = false)
    @Number
    private Long preprodUsagePct;

    public Long getPreprodUsagePct() {
        return preprodUsagePct;
    }

    public PreprodUsagePctParameter withPreprodUsagePct(Long preprodUsagePct) {
        this.preprodUsagePct = preprodUsagePct;
        return this;
    }
}
