package ru.yandex.direct.internaltools.tools.ppcproperties.container;

import java.time.LocalDateTime;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.common.db.PpcPropertyData;
import ru.yandex.direct.common.db.PpcPropertyName;

@ParametersAreNonnullByDefault
public class TypedPropertyInfo {
    private final String name;
    private final String type;
    private final Object value;
    private final LocalDateTime lastChange;

    public TypedPropertyInfo(PpcPropertyName ppcPropertyName, @Nullable PpcPropertyData ppcPropertyData) {
        this.name = ppcPropertyName.getName();
        this.type = ppcPropertyName.getType().getClass().getSimpleName();
        this.value = ppcPropertyData != null ? ppcPropertyData.getValue() : null;
        this.lastChange = ppcPropertyData != null ? ppcPropertyData.getLastChange() : null;
    }

    public String getName() {
        return name;
    }

    public String getType() {
        return type;
    }

    public Object getValue() {
        return value;
    }

    public LocalDateTime getLastChange() {
        return lastChange;
    }
}
