package ru.yandex.direct.internaltools.tools.ppcproperties.preprocessors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.common.db.PpcPropertyName;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.input.InternalToolInput;
import ru.yandex.direct.internaltools.core.input.InternalToolInputPreProcessor;
import ru.yandex.direct.validation.constraint.CommonConstraints;

import static ru.yandex.direct.core.entity.ppcproperty.model.WebEditablePpcProperty.TYPED_PROPS_ALLOWED_TO_EDIT;


@Component
public class TypedPropertyNamesPreprocessor implements InternalToolInputPreProcessor<String> {
    @Override
    public <T extends InternalToolParameter> InternalToolInput.Builder<T, String> preCreate(
            InternalToolInput.Builder<T, String> inputBuilder) {
        Set<String> propertyNames = new HashSet<>();
        List<String> strings = new ArrayList<>();

        strings.add(null);  // чтобы случайно не "убивать" первое по алфавиту свойство
        TYPED_PROPS_ALLOWED_TO_EDIT.stream()
                .map(PpcPropertyName::getName)
                .peek(propertyNames::add)
                .sorted()
                .forEach(strings::add);

        return inputBuilder
                .withDefaultValue(null)
                .withAllowedValues(strings)
                .addValidator(CommonConstraints.inSet(propertyNames));
    }
}
