package ru.yandex.direct.internaltools.tools.pricesales;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.pricepackage.model.PricePackage;
import ru.yandex.direct.core.entity.pricepackage.repository.PricePackageRepository;
import ru.yandex.direct.core.entity.pricepackage.service.PricePackageService;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.implementations.MassInternalTool;
import ru.yandex.direct.internaltools.tools.pricesales.container.PriceSalesPackageInfo;
import ru.yandex.direct.internaltools.tools.pricesales.model.PriceSalesBLMigrParameter;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.internaltools.utils.ToolParameterUtils.getLongIdsFromString;
import static ru.yandex.direct.internaltools.utils.ToolParameterUtils.isStringWithValidLongIds;

@Tool(
        name = "Пакеты с запрещённым BrandLift",
        label = "price_sales_bl_migr",
        description = "Позволяет массово включить брендлифт на пакетах",
        consumes = PriceSalesBLMigrParameter.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.UPDATE)
@Category(InternalToolCategory.PRICE_SALES)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER})
@ParametersAreNonnullByDefault
public class PriceSalesBLMigrTool extends MassInternalTool<PriceSalesBLMigrParameter,
        PriceSalesPackageInfo> {
    private final PricePackageService pricePackageService;
    private final PricePackageRepository pricePackageRepository;
    private final DslContextProvider dslContextProvider;

    public PriceSalesBLMigrTool(PricePackageService pricePackageService,
                                PricePackageRepository pricePackageRepository,
                                DslContextProvider dslContextProvider) {
        this.pricePackageService = pricePackageService;
        this.pricePackageRepository = pricePackageRepository;
        this.dslContextProvider = dslContextProvider;
    }

    @Override
    public ValidationResult<PriceSalesBLMigrParameter, Defect> validate(
            PriceSalesBLMigrParameter parameter) {
        ItemValidationBuilder<PriceSalesBLMigrParameter, Defect> validationBuilder =
                ItemValidationBuilder.of(parameter);
        validationBuilder
                .item(parameter.getPackageIds(), "packageIds")
                .check(isStringWithValidLongIds(1));
        return validationBuilder.getResult();
    }

    @Override
    protected List<PriceSalesPackageInfo> getMassData(PriceSalesBLMigrParameter parameter) {
        Set<Long> packageIds = getLongIdsFromString(parameter.getPackageIds());
        var packagesMap = pricePackageService.getPricePackages(packageIds);
        List<AppliedChanges<PricePackage>> applicableAppliedChanges = new ArrayList<>();
        for (Long id : packagesMap.keySet()) {
            var pricePackage = packagesMap.get(id);
            var options = pricePackage.getCampaignOptions();
            options.setAllowBrandLift(true);
            ModelChanges<PricePackage> changes =
                    ModelChanges.build(id, PricePackage.class, PricePackage.CAMPAIGN_OPTIONS, options);
            applicableAppliedChanges.add(changes.applyTo(pricePackageService.getPricePackage(id)));
        }
        pricePackageRepository.updatePricePackages(dslContextProvider.ppcdict(), applicableAppliedChanges);
        return getMassData();
    }

    @Override
    protected List<PriceSalesPackageInfo> getMassData() {
        //показать список пакетов с запрещённым BrandLift
        return StreamEx.of(pricePackageService.getAllBLOffPricePackages())
                .map(it -> new PriceSalesPackageInfo()
                        .setId(it.getId())
                        .setPricePackageTitle(it.getTitle())
                )
                .toList();
    }
}
