package ru.yandex.direct.internaltools.tools.pricesales.container;


import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.LocalDate;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import static ru.yandex.direct.utils.CommonUtils.nvl;

public class PriceSalesCampaignInfo {
    private static DecimalFormatSymbols symbols;
    private static DecimalFormat formatter;

    static {
        symbols = DecimalFormatSymbols.getInstance();
        symbols.setGroupingSeparator(' ');
        formatter = new DecimalFormat("###,###.##", symbols);
    }

    @JsonProperty("ID кампании")
    private Long campaignId;

    @JsonProperty("Начало кампании")
    private LocalDate startDate;

    @JsonProperty("Окончание кампании")
    private LocalDate endDate;

    @JsonIgnore()
    private Long orderVolume;

    @JsonGetter("Объём заказа")
    public String orderVolumeFormat() {
        return formatter.format(nvl(this.getOrderVolume(), 0));
    }

    @JsonProperty("Пакет")
    private String pricePackageTitle;

    @JsonProperty("Клиент (логин)")
    private String clientLogin;

    @JsonProperty("Клиент (id)")
    private Long clientId;

    @JsonProperty("Агенство (логин)")
    private String agencyLogin;

    @JsonProperty("Агенство (id)")
    private Long agencyClientId;

    @JsonProperty("Деньги на общем счете")
    private String walletMoney;

    @JsonProperty("Регионы показов")
    private String geo;

    @JsonProperty("Таргетинги дефолтной группы")
    private String targeting;

    @JsonIgnore()
    private Long minVolume;

    @JsonGetter("Минимальное число показов")
    public String minShows() {
        return formatter.format(nvl(this.getMinVolume(), 0));
    }

    @JsonIgnore
    private Integer impressionRateCount;

    @JsonIgnore
    private Integer impressionRateIntervalDays;

    @JsonGetter("Ограничение частоты показов")
    public String impressionRate() {
        if (nvl(getImpressionRateCount(), 0) == 0) {
            return "Без ограничения";
        } else {
            return String.format("%d показов %s", getImpressionRateCount(),
                    nvl(getImpressionRateIntervalDays(), 0) == 0 ? "на весь срок кампании" : String.format("на %d дней",
                            getImpressionRateIntervalDays()));
        }
    }

    @JsonProperty("Бизнес юнит")
    private String businessUnitName;

    @JsonProperty("Есть Brand Lift")
    private String brandlift;

    @JsonProperty("Средний дневной бюджет")
    private String avgDayBudget;

    @JsonProperty("Светофор инвентори")
    private String inventoriColor;

    public String getBusinessUnitName() {
        return businessUnitName;
    }

    public PriceSalesCampaignInfo withBusinessUnitName(String businessUnitName) {
        this.businessUnitName = businessUnitName;
        return this;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public PriceSalesCampaignInfo withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public LocalDate getStartDate() {
        return startDate;
    }

    public PriceSalesCampaignInfo withStartDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    public LocalDate getEndDate() {
        return endDate;
    }

    public PriceSalesCampaignInfo withEndDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    public Long getOrderVolume() {
        return orderVolume;
    }

    public PriceSalesCampaignInfo withOrderVolume(Long orderVolume) {
        this.orderVolume = orderVolume;
        return this;
    }

    public String getPricePackageTitle() {
        return pricePackageTitle;
    }

    public PriceSalesCampaignInfo withPricePackageTitle(String pricePackageTitle) {
        this.pricePackageTitle = pricePackageTitle;
        return this;
    }

    public String getClientLogin() {
        return clientLogin;
    }

    public PriceSalesCampaignInfo withClientLogin(String clientLogin) {
        this.clientLogin = clientLogin;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public PriceSalesCampaignInfo withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getAgencyLogin() {
        return agencyLogin;
    }

    public PriceSalesCampaignInfo withAgencyLogin(String agencyLogin) {
        this.agencyLogin = agencyLogin;
        return this;
    }

    public Long getAgencyClientId() {
        return agencyClientId;
    }

    public PriceSalesCampaignInfo withAgencyClientId(Long agencyClientId) {
        this.agencyClientId = agencyClientId;
        return this;
    }

    public String getWalletMoney() {
        return walletMoney;
    }

    public PriceSalesCampaignInfo withWalletMoney(String walletMoney) {
        this.walletMoney = walletMoney;
        return this;
    }

    public String getGeo() {
        return geo;
    }

    public PriceSalesCampaignInfo withGeo(String geo) {
        this.geo = geo;
        return this;
    }

    public String getTargeting() {
        return targeting;
    }

    public PriceSalesCampaignInfo withTargeting(String targeting) {
        this.targeting = targeting;
        return this;
    }

    public Long getMinVolume() {
        return minVolume;
    }

    public PriceSalesCampaignInfo withMinVolume(Long minVolume) {
        this.minVolume = minVolume;
        return this;
    }

    public Integer getImpressionRateCount() {
        return impressionRateCount;
    }

    public PriceSalesCampaignInfo withFrequencyLimit(Integer frequencyLimit) {
        this.impressionRateCount = frequencyLimit;
        return this;
    }

    public String getBrandlift() {
        return brandlift;
    }

    public PriceSalesCampaignInfo withBrandlift(String brandlift) {
        this.brandlift = brandlift;
        return this;
    }

    public String getAvgDayBudget() {
        return avgDayBudget;
    }

    public PriceSalesCampaignInfo withAvgDayBudget(String avgDayBudget) {
        this.avgDayBudget = avgDayBudget;
        return this;
    }

    public String getInventoriColor() {
        return inventoriColor;
    }

    public PriceSalesCampaignInfo withInventoriColor(String inventoriColor) {
        this.inventoriColor = inventoriColor;
        return this;
    }

    @Override
    public String toString() {
        return "PriceSalesCampaignInfo{" +
                "campaignId=" + campaignId +
                ", startDate=" + startDate +
                ", endDate=" + endDate +
                ", orderVolume=" + orderVolume +
                ", pricePackageTitle='" + pricePackageTitle + '\'' +
                ", clientLogin='" + clientLogin + '\'' +
                ", clientId=" + clientId +
                ", agencyLogin='" + agencyLogin + '\'' +
                ", agencyClientId=" + agencyClientId +
                ", walletMoney='" + walletMoney + '\'' +
                ", geo='" + geo + '\'' +
                ", targeting='" + targeting + '\'' +
                ", minVolume=" + minVolume +
                ", impressionRateCount=" + impressionRateCount +
                ", impressionRateIntervalDays=" + impressionRateIntervalDays +
                ", businessUnitName='" + businessUnitName + '\'' +
                ", inventoriColor='" + inventoriColor + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PriceSalesCampaignInfo that = (PriceSalesCampaignInfo) o;
        return Objects.equals(campaignId, that.campaignId) &&
                Objects.equals(startDate, that.startDate) &&
                Objects.equals(endDate, that.endDate) &&
                Objects.equals(orderVolume, that.orderVolume) &&
                Objects.equals(pricePackageTitle, that.pricePackageTitle) &&
                Objects.equals(clientLogin, that.clientLogin) &&
                Objects.equals(clientId, that.clientId) &&
                Objects.equals(agencyLogin, that.agencyLogin) &&
                Objects.equals(agencyClientId, that.agencyClientId) &&
                Objects.equals(walletMoney, that.walletMoney) &&
                Objects.equals(geo, that.geo) &&
                Objects.equals(targeting, that.targeting) &&
                Objects.equals(minVolume, that.minVolume) &&
                Objects.equals(impressionRateCount, that.impressionRateCount) &&
                Objects.equals(impressionRateIntervalDays, that.impressionRateIntervalDays) &&
                Objects.equals(businessUnitName, that.businessUnitName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(campaignId, startDate, endDate, orderVolume, pricePackageTitle, clientLogin, clientId,
                agencyLogin, agencyClientId, walletMoney, geo, targeting, minVolume, impressionRateCount,
                impressionRateIntervalDays, businessUnitName);
    }

    public Integer getImpressionRateIntervalDays() {
        return impressionRateIntervalDays;
    }

    public PriceSalesCampaignInfo withImpressionRateIntervalDays(Integer impressionRateIntervalDays) {
        this.impressionRateIntervalDays = impressionRateIntervalDays;
        return this;
    }
}
