package ru.yandex.direct.internaltools.tools.productrestrictions;

import java.util.Collections;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.product.service.ProductService;
import ru.yandex.direct.internaltools.core.BaseInternalTool;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolMassResult;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Tool(
        name = "Обновление ограничений продукта",
        label = "product_restrictions_update",
        description = "Обновление ограничений продукта",
        consumes = InternalToolParameter.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.SET)
@Category(InternalToolCategory.OTHER)
@AccessGroup({InternalToolAccessRole.DEVELOPER})
@ParametersAreNonnullByDefault
public class ProductRestrictionUpdateTool implements BaseInternalTool<InternalToolParameter> {

    private final ProductService productService;

    public ProductRestrictionUpdateTool(ProductService productService) {
        this.productService = productService;
    }

    @Override
    public final InternalToolMassResult<ProductRestrictionDiffItem> process(InternalToolParameter parameter) {
        productService.replaceProductRestrictions(ProductService.readProductRestrictionFile());

        return processWithoutInput();
    }

    @Override
    public InternalToolMassResult<ProductRestrictionDiffItem> processWithoutInput() {
        var differ = new ProductRestrictionDiffer();
        String diff = differ.getProductRestrictionDiff(
                productService.getProductRestrictionsNoCache(),
                ProductService.readProductRestrictionFile()
        );

        if (diff.equals("")) {
            diff = "Различий не найдено";
        }

        return new InternalToolMassResult<>(Collections.singletonList(new ProductRestrictionDiffItem(diff)));
    }

    /**
     * Человеческой валидации нет, если есть какие-то ошибки то обновление в ядре кинет исключение.
     */
    @Override
    public ValidationResult<InternalToolParameter, Defect> validate(InternalToolParameter param) {
        return new ValidationResult<>(param);
    }
}
