package ru.yandex.direct.internaltools.tools.pushnotifications.model;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.direct.internaltools.core.annotations.input.CheckBox;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@JsonIgnoreProperties(ignoreUnknown = true)
@ParametersAreNonnullByDefault
public class SendInformationalPushParameters extends InternalToolParameter {
    public static final String TEXT_FIELD_NAME = "Текст уведомления";
    public static final String LINK_FIELD_NAME = "Link (с протоколом)";
    public static final String CLIENTID_FIELD_NAME = "Список ClientID (опционально)";
    public static final int MAX_TEXT_SIZE = 512; // из расчёта 4096Б на всё сообщение, 2048 отдаём URL, остальное делим
    @Input(label = TEXT_FIELD_NAME)
    @Text(valueMaxLen = MAX_TEXT_SIZE)
    private String text;
    @Input(label = LINK_FIELD_NAME)
    @Text(valueMaxLen = 2047)
    private String url;
    @Input(label = CLIENTID_FIELD_NAME, required = false)
    @TextArea
    private String clientId;
    @Input(label = "Отправить всем")
    @CheckBox(checked = false)
    private Boolean sendToEveryone;
    @Input(label = "Да, серьёзно, отправить всем")
    @CheckBox(checked = false)
    private Boolean reallySendToEveryone;

    public Boolean getSendToEveryone() {
        return sendToEveryone;
    }

    public void setSendToEveryone(Boolean sendToEveryone) {
        this.sendToEveryone = sendToEveryone;
    }

    public Boolean getReallySendToEveryone() {
        return reallySendToEveryone;
    }

    public void setReallySendToEveryone(Boolean reallySendToEveryone) {
        this.reallySendToEveryone = reallySendToEveryone;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Nullable
    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }
}
