package ru.yandex.direct.internaltools.tools.redirects.container;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Контейнер для описания проверки домена
 */
@ParametersAreNonnullByDefault
public class RedirectCheckQueueItem {
    @JsonProperty("Домен")
    private String domain;

    @JsonProperty("Количество объявлений")
    private Integer bannersNum;

    @JsonProperty("Количество кампаний")
    private Integer campaignsNum;

    @JsonProperty("Максимальное ожидание (сек.)")
    private Long secondsInQueue;

    public String getDomain() {
        return domain;
    }

    public RedirectCheckQueueItem withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public Integer getBannersNum() {
        return bannersNum;
    }

    public RedirectCheckQueueItem withBannersNum(Integer bannersNum) {
        this.bannersNum = bannersNum;
        return this;
    }

    public Integer getCampaignsNum() {
        return campaignsNum;
    }

    public RedirectCheckQueueItem withCampaignsNum(Integer campaignsNum) {
        this.campaignsNum = campaignsNum;
        return this;
    }

    public Long getSecondsInQueue() {
        return secondsInQueue;
    }

    public RedirectCheckQueueItem withSecondsInQueue(Long secondsInQueue) {
        this.secondsInQueue = secondsInQueue;
        return this;
    }
}
