package ru.yandex.direct.internaltools.tools.redirects.model;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@ParametersAreNonnullByDefault
public class RedirectCheckQueueParameters extends InternalToolParameter {
    @TextArea
    @Input(label = "Список кампаний для перепроверки (cid'ы):", required = false,
            description = "номера кампаний должны быть отделены друг от друга запятой или любым whitespace символом")
    private String campaignIds;

    @TextArea
    @Input(label = "Список баннеров для перепроверки (bid'ы):", required = false,
            description = "номера баннеров должны быть отделены друг от друга запятой или любым whitespace символом")
    private String bannerIds;

    public String getCampaignIds() {
        return campaignIds;
    }

    public RedirectCheckQueueParameters withCampaignIds(String campaignIds) {
        this.campaignIds = campaignIds;
        return this;
    }

    public String getBannerIds() {
        return bannerIds;
    }

    public RedirectCheckQueueParameters withBannerIds(String bannerIds) {
        this.bannerIds = bannerIds;
        return this;
    }
}
