package ru.yandex.direct.internaltools.tools.searchspamusers.container;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

@ParametersAreNonnullByDefault
public class SearchSpamUsersInfo {
    @JsonIgnore
    private Long uid;

    @Enrich(InternalToolDetailKey.LOGIN_CLIENT_CAMPAIGNS_LINK_REPLACE)
    @JsonProperty("Логин")
    private String login;

    @Enrich(InternalToolDetailKey.FIO_CLIENT_CAMPAIGNS_LINK_REPLACE)
    @JsonProperty("ФИО")
    private String fio;

    @Enrich(InternalToolDetailKey.BOOLEAN_REPLACE)
    @JsonProperty("Заблокирован")
    private Boolean blocked;

    @JsonProperty("Домен")
    private String domain;

    @JsonProperty("Отклонено")
    private Integer denied;

    @JsonProperty("Принято")
    private Integer accepted;

    @Enrich(InternalToolDetailKey.IP_WHOIS_LINK_REPLACE)
    @JsonProperty("IP")
    private String ip;

    public Long getUid() {
        return uid;
    }

    public String getLogin() {
        return login;
    }

    public String getFio() {
        return fio;
    }

    public Boolean getBlocked() {
        return blocked;
    }

    public String getDomain() {
        return domain;
    }

    public Integer getDenied() {
        return denied;
    }

    public Integer getAccepted() {
        return accepted;
    }

    public String getIp() {
        return ip;
    }


    public SearchSpamUsersInfo withUid(Long uid) {
        this.uid = uid;
        return this;
    }

    public SearchSpamUsersInfo withLogin(String login) {
        this.login = login;
        return this;
    }

    public SearchSpamUsersInfo withFio(String fio) {
        this.fio = fio;
        return this;
    }

    public SearchSpamUsersInfo withBlocked(Boolean blocked) {
        this.blocked = blocked;
        return this;
    }

    public SearchSpamUsersInfo withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public SearchSpamUsersInfo withDenied(Integer denied) {
        this.denied = denied;
        return this;
    }

    public SearchSpamUsersInfo withAccepted(Integer accepted) {
        this.accepted = accepted;
        return this;
    }

    public SearchSpamUsersInfo withIp(String ip) {
        this.ip = ip;
        return this;
    }
}
