package ru.yandex.direct.internaltools.tools.searchspamusers.model;

import java.math.BigDecimal;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbschema.ppc.enums.UsersStatusblocked;

@ParametersAreNonnullByDefault
public class SearchSpamUsersFetchData {
    private String login;
    private Long uid;
    private UsersStatusblocked usersStatusblocked;
    private String domains;
    private BigDecimal acceptedCount;
    private BigDecimal declinedCount;
    private String ip;

    public SearchSpamUsersFetchData(String login, Long uid,
                                    UsersStatusblocked usersStatusblocked, String domains, BigDecimal acceptedCount,
                                    BigDecimal declinedCount) {
        this.login = login;
        this.uid = uid;
        this.usersStatusblocked = usersStatusblocked;
        this.domains = domains;
        this.acceptedCount = acceptedCount;
        this.declinedCount = declinedCount;
    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public Long getUid() {
        return uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public UsersStatusblocked getUsersStatusblocked() {
        return usersStatusblocked;
    }

    public void setUsersStatusblocked(UsersStatusblocked usersStatusblocked) {
        this.usersStatusblocked = usersStatusblocked;
    }

    public String getDomains() {
        return domains;
    }

    public void setDomains(String domains) {
        this.domains = domains;
    }

    public BigDecimal getAcceptedCount() {
        return acceptedCount;
    }

    public void setAcceptedCount(BigDecimal acceptedCount) {
        this.acceptedCount = acceptedCount;
    }

    public BigDecimal getDeclinedCount() {
        return declinedCount;
    }

    public void setDeclinedCount(BigDecimal declinedCount) {
        this.declinedCount = declinedCount;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public SearchSpamUsersFetchData withIp(String ip) {
        this.ip = ip;
        return this;
    }
}
