package ru.yandex.direct.internaltools.tools.searchspamusers.model;

import java.time.LocalDate;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.direct.internaltools.core.annotations.input.Date;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@JsonIgnoreProperties(ignoreUnknown = true)
@ParametersAreNonnullByDefault
public class SearchSpamUsersParameters extends InternalToolParameter {
    @Input(label = "Логины", required = false, description = "можно указывать несколько логинов через запятую")
    @TextArea(rows = 5, columns = 48)
    private String logins;

    @Input(label = "Исходный IP", required = false)
    @Text(valueMaxLen = 48, fieldLen = 48)
    private String ip;

    @Input(label = "Тип лога для поиска", description = "искать в логах API или CMD")
    private SearchSpamUsersLogTableEnum logTable;

    @Date(today = true)
    @Input(label = "c:")
    private LocalDate dateFrom;

    @Date(today = true)
    @Input(label = "по:", description = "можно делать запрос за период не превышающий 30 дней")
    private LocalDate dateTo;

    public String getLogins() {
        return logins;
    }

    public SearchSpamUsersParameters withLogins(String logins) {
        this.logins = logins;
        return this;
    }

    public String getIp() {
        return ip;
    }

    public SearchSpamUsersParameters withIp(String ip) {
        this.ip = ip;
        return this;
    }

    public LocalDate getDateFrom() {
        return dateFrom;
    }

    public SearchSpamUsersParameters withDateFrom(LocalDate dateFrom) {
        this.dateFrom = dateFrom;
        return this;
    }

    public LocalDate getDateTo() {
        return dateTo;
    }

    public SearchSpamUsersParameters withDateTo(LocalDate dateTo) {
        this.dateTo = dateTo;
        return this;
    }

    public SearchSpamUsersLogTableEnum getLogTable() {
        return logTable;
    }

    public SearchSpamUsersParameters withLogTable(
            SearchSpamUsersLogTableEnum logTable) {
        this.logTable = logTable;
        return this;
    }
}
