package ru.yandex.direct.internaltools.tools.searchspamusers.service;

import java.util.function.Predicate;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.internaltools.tools.searchspamusers.model.SearchSpamUsersParameters;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.defect.CommonDefects;
import ru.yandex.direct.validation.result.Defect;

@Service
@ParametersAreNonnullByDefault
public class SearchSpamUsersValidationService {
    public static final int MAX_RANGE_IN_DAYS = 30;

    private SearchSpamUsersValidationService() {
    }

    public static Constraint<SearchSpamUsersParameters, Defect> loginsOrIpPresentInParameters() {
        return Constraint.fromPredicate(loginsOrIpPresent(), CommonDefects.absentRequiredField());
    }

    private static Predicate<SearchSpamUsersParameters> loginsOrIpPresent() {
        return parameters -> (parameters.getLogins() != null && parameters.getLogins().trim().length() > 0) || (
                parameters.getIp() != null
                        && parameters.getIp().trim().length() > 0);
    }
}

