package ru.yandex.direct.internaltools.tools.social.models;

import ru.yandex.direct.internaltools.core.annotations.input.CheckBox;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class InternalToolsSocialAdvertisingFeature extends InternalToolParameter {
    public static final String LOGINS = "LOGINS";

    @Input(label = "Логины клиентов, через запятую")
    @TextArea
    private String clientLogins;

    @Input(label = "Клиентам разрешено платить")
    @CheckBox(checked = true)
    private Boolean isPaymentAllowed;

    @Input(label = "Подключить")
    @CheckBox(checked = true)
    private Boolean isAdvEnabled;

    public String getClientLogins() {
        return clientLogins;
    }

    public InternalToolsSocialAdvertisingFeature withClientLogins(String clientLogins) {
        this.clientLogins = clientLogins;
        return this;
    }

    public Boolean getIsPaymentAllowed() {
        return isPaymentAllowed;
    }

    public InternalToolsSocialAdvertisingFeature withPaymentAllowed(Boolean paymentAllowed) {
        isPaymentAllowed = paymentAllowed;
        return this;
    }

    public Boolean getIsAdvEnabled() {
        return isAdvEnabled;
    }

    public InternalToolsSocialAdvertisingFeature withAdvEnabled(Boolean enabled) {
        isAdvEnabled = enabled;
        return this;
    }
}
