package ru.yandex.direct.internaltools.tools.social.models;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

public class InternalToolsSocialClientInfo {
    @JsonProperty("ClientID")
    private Long clientId;

    @JsonProperty("login главного представителя")
    private String chiefLogin;

    @JsonProperty("uid главного представителя")
    private Long chiefUid;

    @JsonProperty("Оплата разрешена")
    @Enrich(InternalToolDetailKey.BOOLEAN_REPLACE)
    private Boolean isPaymentAllowed;

    public Long getClientId() {
        return clientId;
    }

    public InternalToolsSocialClientInfo withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Boolean getIsPaymentAllowed() {
        return isPaymentAllowed;
    }

    public InternalToolsSocialClientInfo withIsEnabled(Boolean enabled) {
        isPaymentAllowed = enabled;
        return this;
    }

    public String getChiefLogin() {
        return chiefLogin;
    }

    public InternalToolsSocialClientInfo withChiefLogin(String chiefLogin) {
        this.chiefLogin = chiefLogin;
        return this;
    }

    public Long getChiefUid() {
        return chiefUid;
    }

    public InternalToolsSocialClientInfo withChiefUid(Long uid) {
        this.chiefUid = uid;
        return this;
    }
}
