package ru.yandex.direct.internaltools.tools.social.models;

import com.fasterxml.jackson.annotation.JsonProperty;

public class InternalToolsSocialFeatureResponse {
    @JsonProperty("ClientID")
    private Long clientId;

    @JsonProperty("login")
    private String login;

    @JsonProperty("login главного представителя")
    private String chiefLogin;

    @JsonProperty("Разрешена оплата")
    private Boolean paymentAllowed;

    @JsonProperty("Подключена реклама")
    private Boolean advEnabled;

    public String getLogin() {
        return login;
    }

    public InternalToolsSocialFeatureResponse withLogin(String login) {
        this.login = login;
        return this;
    }

    public String getChiefLogin() {
        return chiefLogin;
    }

    public InternalToolsSocialFeatureResponse withChiefLogin(String chiefLogin) {
        this.chiefLogin = chiefLogin;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public InternalToolsSocialFeatureResponse withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Boolean getPaymentAllowed() {
        return paymentAllowed;
    }

    @Override
    public String toString() {
        return "InternalToolsSocialFeatureResponse{" +
                "clientId=" + clientId +
                ", login='" + login + '\'' +
                ", chiefLogin='" + chiefLogin + '\'' +
                ", paymentAllowed=" + paymentAllowed +
                ", advEnabled=" + advEnabled +
                '}';
    }

    public InternalToolsSocialFeatureResponse withPaymentAllowed(Boolean paymentAllowed) {
        this.paymentAllowed = paymentAllowed;
        return this;
    }

    public Boolean getAdvEnabled() {
        return advEnabled;
    }

    public InternalToolsSocialFeatureResponse withAdvEnabled(Boolean enabled) {
        advEnabled = enabled;
        return this;
    }
}
