package ru.yandex.direct.internaltools.tools.somebalancenotifications;

import java.time.format.DateTimeFormatter;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.balance.service.BalanceInfoQueueService;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.implementations.MassInternalToolWithoutParam;
import ru.yandex.direct.utils.FunctionalUtils;

@Tool(
        name = "Специальные нотификации в Баланс",
        label = "latest_balance_info_queue_records",
        description = "До 100 последних нотификаций на каждый шард в баланс, "
                + "отправленных через спец. очередь(balance_info_queue)",
        consumes = InternalToolParameter.class,
        type = InternalToolType.REPORT
)
@Action(InternalToolAction.REFRESH)
@Category(InternalToolCategory.OTHER)
@ParametersAreNonnullByDefault
public class SomeBalanceNotificationsInternalTool extends MassInternalToolWithoutParam<SomeBalanceNotificationsInfo> {
    private static final int LIMIT = 100;
    private final BalanceInfoQueueService balanceInfoQueueService;

    @Autowired
    public SomeBalanceNotificationsInternalTool(BalanceInfoQueueService balanceInfoQueueService) {
        this.balanceInfoQueueService = balanceInfoQueueService;
    }

    @Override
    protected List<SomeBalanceNotificationsInfo> getMassData() {
        return FunctionalUtils
                .mapList(balanceInfoQueueService.getLatestRecords(LIMIT),
                        balanceInfoQueueItem -> new SomeBalanceNotificationsInfo()
                                .withCidOrUid(balanceInfoQueueItem.getCidOrUid())
                                .withObjType(balanceInfoQueueItem.getObjType().name())
                                .withOperatorUid(balanceInfoQueueItem.getOperatorUid())
                                .withAddTime(
                                        balanceInfoQueueItem.getAddTime().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME))
                                .withPriority(balanceInfoQueueItem.getPriority())
                                .withSendStatus(balanceInfoQueueItem.getSendStatus().name()));
    }
}
