package ru.yandex.direct.internaltools.tools.takeout.model;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@JsonIgnoreProperties(ignoreUnknown = true)
@ParametersAreNonnullByDefault
public class UnarchiveJobParameters extends InternalToolParameter {
    public static final String JOB_IDS = "job_id из dbqueue_job_archive через запятую";

    @Input(label = JOB_IDS)
    @TextArea
    private String jobIds;

    public void setJobId(String jobIds) {
        this.jobIds = jobIds;
    }

    public String getJobIds() {
        return jobIds;
    }

    public Set<Long> getJobIdsSet() {
        return Arrays.stream(jobIds.split(","))
                .map(Long::parseLong)
                .collect(Collectors.toSet());
    }
}
