package ru.yandex.direct.internaltools.tools.telephony.model;

import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class UnlinkUnusedTelephonyParameters extends InternalToolParameter {

    public enum Action {
        UNLINK_PHONE("Отвязать номер");

        private final String description;

        Action(String description) {
            this.description = description;
        }

        @JsonValue
        public String getDescription() {
            return description;
        }
    }

    @Select
    @Input(label = "Действие")
    private UnlinkUnusedTelephonyParameters.Action action;

    @TextArea
    @Input(label = "Список clientPhoneId для удаления")
    private String clientPhoneIds;

    public Action getAction() {
        return action;
    }

    public String getClientPhoneIds() {
        return clientPhoneIds;
    }

}
