package ru.yandex.direct.internaltools.tools.templates.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.internalads.model.DirectTemplateState;

public class TemplateInfo {
    @JsonProperty("Id шаблона")
    private Long directTemplateId;
    @JsonProperty("Имя формата шаблона")
    private String formatName;
    @JsonProperty("Состояние шаблона")
    private DirectTemplateState state;
    @JsonProperty("Список площадок: id")
    private List<String> places;
    @JsonProperty("Список ресурсов: номер ресурса единого шаблона - опции - описание")
    private List<String> resourcesDetailed;
    @JsonProperty("Список ресурсов для редактирования: номер ресурса единого шаблона - required")
    private String resourcesBasic;

    public Long getDirectTemplateId() {
        return directTemplateId;
    }

    public TemplateInfo withDirectTemplateId(Long directTemplateId) {
        this.directTemplateId = directTemplateId;
        return this;
    }

    public String getFormatName() {
        return formatName;
    }

    public TemplateInfo withFormatName(String formatName) {
        this.formatName = formatName;
        return this;
    }

    public DirectTemplateState getState() {
        return state;
    }

    public TemplateInfo withState(DirectTemplateState state) {
        this.state = state;
        return this;
    }

    public List<String> getPlaces() {
        return places;
    }

    public TemplateInfo withPlaces(List<String> places) {
        this.places = places;
        return this;
    }

    public List<String> getResourcesDetailed() {
        return resourcesDetailed;
    }

    public TemplateInfo withResourcesDetailed(List<String> resourcesDetailed) {
        this.resourcesDetailed = resourcesDetailed;
        return this;
    }

    public String getResourcesBasic() {
        return resourcesBasic;
    }

    public TemplateInfo withResourcesBasic(String resourcesBasic) {
        this.resourcesBasic = resourcesBasic;
        return this;
    }
}
