package ru.yandex.direct.internaltools.tools.templates.model;

import ru.yandex.direct.core.entity.internalads.model.DirectTemplateState;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

import static ru.yandex.direct.internaltools.tools.templates.tool.TemplateUtil.MIN_NEW_TEMPLATE_ID;
import static ru.yandex.direct.internaltools.tools.templates.tool.TemplateUtil.SPECIFIC_VALUE_TO_CLEAR_PLACE_IDS;

public class TemplateInput extends InternalToolParameter {
    public static final String ACTION_LABEL = "Действие";
    public static final String DIRECT_TEMPLATE_ID_LABEL = "Id шаблона (ppcdict.direct_template.direct_template_id)";
    public static final String FORMAT_NAME_LABEL = "Имя формата для единого шаблона";
    public static final String STATE_LABEL = "Состояние шаблона (способ отправки в БК)";
    public static final String PLACE_IDS_LABEL = "Список id площадок шаблона";
    public static final String RESOURCES_LABEL = "Список ресурсов шаблона";

    @Input(label = ACTION_LABEL)
    private TemplateAction templateAction;

    @Input(label = DIRECT_TEMPLATE_ID_LABEL, required = false,
            description = "Поле обязательно при изменении/копировании/удалении шаблона; " +
                    "не учитывается при создании шаблона")
    private Long directTemplateId;

    @Input(label = FORMAT_NAME_LABEL, required = false,
            description = "Поле обязательно при создании шаблона. " +
                    "Пустое значение при изменении шаблона оставит оригинальное значение. " +
                    "Задать пустое значение для смигрированных шаблонов (id < " + MIN_NEW_TEMPLATE_ID + ") можно, " +
                    "передав в это поле 0")
    private String formatName;

    @Input(label = STATE_LABEL, required = false,
            description = "Поле не учитывается при создании шаблона - используется UNIFIED. " +
                    "Пустое значение при изменении шаблона оставит оригинальное значение. " +
                    "Новые шаблоны (id >=" + MIN_NEW_TEMPLATE_ID + ") могут иметь только состояние UNIFIED")
    private DirectTemplateState state;

    @TextArea
    @Input(label = PLACE_IDS_LABEL, required = false,
            description = "Список id площадок через запятую. " +
                    "Пустое значение при изменении шаблона оставит оригинальное значение. " +
                    "Очистить список площадок полностью можно, передав в это поле " + SPECIFIC_VALUE_TO_CLEAR_PLACE_IDS)
    private String placeIds;

    @TextArea
    @Input(label = RESOURCES_LABEL, required = false,
            description = "Поле обязательно при создании и редактировании шаблона. " +
                    "Упорядоченный список пар 'номер ресурса единого шаблона - обязательность ресурса (0 или 1)'. " +
                    "Элементы в паре должны быть разделены пробелами или запятыми. " +
                    "Пары должны быть разделены символом '|', переносом строки или возвратом каретки")
    private String resources;


    public TemplateAction getTemplateAction() {
        return templateAction;
    }

    public TemplateInput withTemplateAction(TemplateAction templateAction) {
        this.templateAction = templateAction;
        return this;
    }

    public Long getDirectTemplateId() {
        return directTemplateId;
    }

    public TemplateInput withDirectTemplateId(Long directTemplateId) {
        this.directTemplateId = directTemplateId;
        return this;
    }

    public String getFormatName() {
        return formatName;
    }

    public TemplateInput withFormatName(String formatName) {
        this.formatName = formatName;
        return this;
    }

    public DirectTemplateState getState() {
        return state;
    }

    public TemplateInput withState(DirectTemplateState state) {
        this.state = state;
        return this;
    }

    public String getPlaceIds() {
        return placeIds;
    }

    public TemplateInput withPlaceIds(String placeIds) {
        this.placeIds = placeIds;
        return this;
    }

    public String getResources() {
        return resources;
    }

    public TemplateInput withResources(String resources) {
        this.resources = resources;
        return this;
    }

    @Override
    public String toString() {
        return "TemplateInput{" +
                "action=" + templateAction +
                ", directTemplateId=" + directTemplateId +
                ", formatName=" + formatName +
                ", state=" + state +
                ", placeIds=" + placeIds +
                ", resources=" + resources +
                '}';
    }
}
