package ru.yandex.direct.internaltools.tools.templates.model;

import ru.yandex.direct.internaltools.core.annotations.input.CheckBox;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class TemplateResourceMapping extends InternalToolParameter {
    public static final String TEMPLATE_ID_LABEL = "id шаблона";
    public static final String FORMAT_LABEL = "формат";
    public static final String RESOURCE_NO_MAPPING_LABEL = "маппинг ";

    @Input(label = TEMPLATE_ID_LABEL, description = "какой шаблон мигрируется")
    private Long templateId;

    @Input(label = FORMAT_LABEL, description = "значение ресурса «формат». Чтобы задать пустое значение, передайте 0")
    private String format;

    @TextArea
    @Input(label = RESOURCE_NO_MAPPING_LABEL, description = "пары ResourceNo старого и единого шаблонов")
    private String mapping;

    @CheckBox(checked = false)
    @Input(label = "мигрировать уже смигрированный шаблон", description = "перезаписать старый маппинг")
    private boolean redoMigration;

    public Long getTemplateId() {
        return templateId;
    }

    public TemplateResourceMapping withtemplateId(Long templateId) {
        this.templateId = templateId;
        return this;
    }

    public String getFormat() {
        return format;
    }

    public TemplateResourceMapping withFormat(String format) {
        this.format = format;
        return this;
    }

    public String getMapping() {
        return mapping;
    }

    public TemplateResourceMapping withMapping(String mapping) {
        this.mapping = mapping;
        return this;
    }

    public boolean isRedoMigration() {
        return redoMigration;
    }

    public TemplateResourceMapping withRedoMigration(boolean redoMigration) {
        this.redoMigration = redoMigration;
        return this;
    }
}
