package ru.yandex.direct.internaltools.tools.templates.tool;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import ru.yandex.direct.core.entity.internalads.model.DirectTemplateResourceOption;
import ru.yandex.direct.core.entity.internalads.model.TemplateResource;
import ru.yandex.direct.core.entity.internalads.model.TemplateResourceOption;

public class TemplateUtil {
    static final long UNIFIED_TEMPLATE_ID = 3350L;
    static final int MAX_FORMAT_NAME_LENGTH = 255;
    public static final long MIN_NEW_TEMPLATE_ID = 1_000_000L;
    public static final long SPECIFIC_VALUE_TO_CLEAR_PLACE_IDS = 0L;

    static Set<DirectTemplateResourceOption> convertOptions(Set<TemplateResourceOption> option) {
        var result = new HashSet<DirectTemplateResourceOption>();
        if (option.contains(TemplateResourceOption.BANANA_URL)) {
            result.add(DirectTemplateResourceOption.BANANA_URL);
        }
        if (option.contains(TemplateResourceOption.BANANA_IMAGE)) {
            result.add(DirectTemplateResourceOption.BANANA_IMAGE);
        }
        if (option.contains(TemplateResourceOption.REQUIRED)) {
            result.add(DirectTemplateResourceOption.REQUIRED);
        }
        return result;
    }

    /**
     * Фильтрует список ресурсов по номерам и id шаблона
     * и возвращает словарь ресурсов по их номерам.
     *
     * @param resourceNos - номера ресурсов, которые могут быть ключами в словаре
     * @param resources   - список ресурсов
     * @param templateId  - id шаблона
     * @return словарь номер ресурса -> ресурс
     */
    static Map<Long, TemplateResource> getResourcesByNosMap(Collection<Long> resourceNos,
                                                            Collection<TemplateResource> resources,
                                                            long templateId) {
        var nosSet = new HashSet<>(resourceNos);
        var result = new HashMap<Long, TemplateResource>();
        for (var resource : resources) {
            if (resource.getTemplateId() == templateId && nosSet.contains(resource.getResourceNo())) {
                result.put(resource.getResourceNo(), resource);
            }
        }
        return result;
    }
}
