package ru.yandex.direct.internaltools.tools.touchcamp;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.campaign.model.TextCampaign;
import ru.yandex.direct.core.entity.campaign.repository.CampaignTypedRepository;
import ru.yandex.direct.core.entity.campaign.service.CampaignOperationService;
import ru.yandex.direct.core.entity.campaign.service.CampaignOptions;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.model.UidAndClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.internaltools.core.BaseInternalTool;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolResult;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.tools.touchcamp.model.TouchCampToolParameter;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.result.MassResult;

@Tool(
        name = "Выставление флажка is_touch на кампании",
        label = "touch_camp_tool",
        description = "",
        consumes = TouchCampToolParameter.class,
        type = InternalToolType.WRITER
)
@Category(InternalToolCategory.OTHER)
@Action(InternalToolAction.SET)
@AccessGroup({InternalToolAccessRole.SUPER})
@ParametersAreNonnullByDefault
public class TouchCampTool implements BaseInternalTool<TouchCampToolParameter> {

    private final CampaignOperationService campaignOperationService;
    private final CampaignTypedRepository campaignTypedRepository;
    private final ShardHelper shardHelper;

    @Autowired
    public TouchCampTool(
            CampaignOperationService campaignOperationService,
            CampaignTypedRepository campaignTypedRepository,
            ShardHelper shardHelper
    ) {
        this.campaignOperationService = campaignOperationService;
        this.campaignTypedRepository = campaignTypedRepository;
        this.shardHelper = shardHelper;
    }

    @Override
    public InternalToolResult process(TouchCampToolParameter touchCampToolParameter) {
        int shard = shardHelper.getShardByCampaignId(touchCampToolParameter.getCampaignId());
        List<? extends BaseCampaign> typedCampaigns =
                campaignTypedRepository.getTypedCampaigns(shard, List.of(touchCampToolParameter.getCampaignId()));
        // должны упасть на не-ТГО кампаниях. Ну и ладно
        TextCampaign camp = (TextCampaign) typedCampaigns.get(0);
        List<ModelChanges<TextCampaign>> modelChanges = List.of(
                new ModelChanges<>(camp.getId(), TextCampaign.class)
                        .process(touchCampToolParameter.isTouch(), TextCampaign.IS_TOUCH)
        );
        var options = new CampaignOptions();
        var updateOperation = campaignOperationService.createRestrictedCampaignUpdateOperation(
                modelChanges,
                touchCampToolParameter.getOperator().getUid(),
                // uid и ClientID субъекта берём от самой кампании, т.к. это инструмент для супера и суперам так можно
                UidAndClientId.of(camp.getUid(), ClientId.fromLong(camp.getClientId())),
                options
        );
        MassResult<Long> updateResult = updateOperation.apply();
        if (updateResult.isSuccessful() && updateResult.getErrorCount() == 0) {
            return new InternalToolResult("OK");
        }
        return new InternalToolResult("NOT OK: " + updateResult.getValidationResult().flattenErrors().toString());
    }
}
