package ru.yandex.direct.internaltools.tools.traceinterceptions;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.BaseInternalTool;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolMassResult;
import ru.yandex.direct.internaltools.core.container.InternalToolResult;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.tools.traceinterceptions.model.TraceInterceptionConverter;
import ru.yandex.direct.internaltools.tools.traceinterceptions.model.TraceInterceptionInfo;
import ru.yandex.direct.internaltools.tools.traceinterceptions.model.TraceInterceptionInput;
import ru.yandex.direct.traceinterception.entity.traceinterception.service.TraceInterceptionsManagingService;
import ru.yandex.direct.traceinterception.model.TraceInterception;
import ru.yandex.direct.traceinterception.model.TraceInterceptionAction;
import ru.yandex.direct.traceinterception.model.TraceInterceptionCondition;

import static ru.yandex.direct.internaltools.tools.traceinterceptions.model.TraceInterceptionInput.convertInputConditionValue;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Tool(
        name = "Добавление правил перехвата",
        label = "create_trace_interceptions",
        description = "Добавление правил перехвата трейсинга в Директе. У правил есть условие (фильтр), которое " +
                "накладывает ограничение на его область применения, действие - то, что нужно выполнить при наступлении условия, " +
                "и статус - активно правило или нет.",
        consumes = TraceInterceptionInput.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.ADD)
@Category(InternalToolCategory.TRACE_INTERCEPTIONS)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER})
@ParametersAreNonnullByDefault
public class TraceInterceptionsCreateTool implements BaseInternalTool<TraceInterceptionInput> {
    TraceInterceptionsManagingService traceInterceptionsManagingService;

    public TraceInterceptionsCreateTool(TraceInterceptionsManagingService traceInterceptionsManagingService) {
        this.traceInterceptionsManagingService = traceInterceptionsManagingService;
    }

    @Override
    public InternalToolMassResult<TraceInterceptionInfo> processWithoutInput() {
        return new InternalToolMassResult<>(mapList(traceInterceptionsManagingService.getCached(),
                TraceInterceptionConverter::createTraceInterceptionInfo));
    }

    @Override
    public final InternalToolResult process(TraceInterceptionInput input) {
        TraceInterception traceInterception = new TraceInterception()
                .withCondition(new TraceInterceptionCondition()
                        .withService(convertInputConditionValue(input.getService()))
                        .withMethod(convertInputConditionValue(input.getMethod()))
                        .withFunc(convertInputConditionValue(input.getFunc()))
                        .withTags(convertInputConditionValue(input.getTags())))
                .withAction(new TraceInterceptionAction()
                        .withSleepDuration(input.getSleepDuration())
                        .withExceptionMessage(input.getExceptionMessage())
                        .withSemaphoreKey(input.getSemaphoreKey())
                        .withSemaphorePermits(input.getSemaphorePermits() != null ? input.getSemaphorePermits().intValue() : null))
                .withStatus(input.getStatus());

        traceInterceptionsManagingService.add(traceInterception);
        return processWithoutInput();
    }
}
