package ru.yandex.direct.internaltools.tools.traceinterceptions;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.BaseInternalTool;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolResult;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.tools.traceinterceptions.model.TraceInterceptionRemoveInput;
import ru.yandex.direct.traceinterception.entity.traceinterception.service.TraceInterceptionsManagingService;

import static ru.yandex.direct.internaltools.tools.traceinterceptions.model.TraceInterceptionUpdateSelectProvider.extractId;

@Tool(
        name = "Удаление правил перехвата",
        label = "remove_trace_interceptions",
        description = "Если выключить правило нужно на время, то лучше поменять статус на другой страничке.",
        consumes = TraceInterceptionRemoveInput.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.DELETE)
@Category(InternalToolCategory.TRACE_INTERCEPTIONS)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER})
@ParametersAreNonnullByDefault
public class TraceInterceptionsRemoveTool implements BaseInternalTool<TraceInterceptionRemoveInput> {
    TraceInterceptionsManagingService managingService;

    public TraceInterceptionsRemoveTool(TraceInterceptionsManagingService traceInterceptionsManagingService) {
        this.managingService = traceInterceptionsManagingService;
    }

    @Override
    public final InternalToolResult process(TraceInterceptionRemoveInput input) {
        boolean isRemoved = managingService.removeInterceptionById(extractId(input.getId()));
        return new InternalToolResult(isRemoved ? "Правило удалено" : "Правило отсутствует в базе");
    }
}
