package ru.yandex.direct.internaltools.tools.traceinterceptions;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.BaseInternalTool;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolMassResult;
import ru.yandex.direct.internaltools.core.container.InternalToolResult;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.tools.traceinterceptions.model.TraceInterceptionConverter;
import ru.yandex.direct.internaltools.tools.traceinterceptions.model.TraceInterceptionInfo;
import ru.yandex.direct.internaltools.tools.traceinterceptions.model.TraceInterceptionUpdateStatusInput;
import ru.yandex.direct.traceinterception.entity.traceinterception.service.TraceInterceptionsManagingService;

import static ru.yandex.direct.internaltools.tools.traceinterceptions.model.TraceInterceptionUpdateSelectProvider.extractId;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Tool(
        name = "Включение/выключение правил перехвата",
        label = "edit_trace_interceptions_status",
        description = "Редактирование статуса правила",
        consumes = TraceInterceptionUpdateStatusInput.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.UPDATE)
@Category(InternalToolCategory.TRACE_INTERCEPTIONS)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER})
@ParametersAreNonnullByDefault
public class TraceInterceptionsUpdateStatusTool implements BaseInternalTool<TraceInterceptionUpdateStatusInput> {
    TraceInterceptionsManagingService managingService;

    public TraceInterceptionsUpdateStatusTool(TraceInterceptionsManagingService traceInterceptionsManagingService) {
        this.managingService = traceInterceptionsManagingService;
    }

    @Override
    public InternalToolMassResult<TraceInterceptionInfo> processWithoutInput() {
        return new InternalToolMassResult<>(mapList(managingService.getCached(),
                TraceInterceptionConverter::createTraceInterceptionInfo));
    }

    @Override
    public final InternalToolResult process(TraceInterceptionUpdateStatusInput input) {
        managingService.updateInterceptionWithStatusById(extractId(input.getId()), input.getStatus());
        return processWithoutInput();
    }
}
