package ru.yandex.direct.internaltools.tools.traceinterceptions.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonValue;

@ParametersAreNonnullByDefault
public enum TraceInterceptionActionType {
    SLEEP("Продолжительность сна (в мс)"),
    EXCEPTION("Сообщение исключения"),
    SEMAPHORE_KEY("Ключ семафора"),
    SEMAPHORE("Значение семафора");

    private String description;

    TraceInterceptionActionType(String description) {
        this.description = description;
    }

    @JsonValue
    public String getDescription() {
        return description;
    }

    @Override
    public String toString() {
        return getDescription();
    }
}
