package ru.yandex.direct.internaltools.tools.traceinterceptions.model;

import ru.yandex.direct.traceinterception.model.TraceInterception;
import ru.yandex.direct.utils.JsonUtils;

import static ru.yandex.direct.traceinterception.entity.traceinterception.model.TraceInterceptionsStorage.getSemaphoreKey;

public class TraceInterceptionConverter {
    private TraceInterceptionConverter() {
    }

    public static TraceInterceptionInfo createTraceInterceptionInfo(TraceInterception traceInterception) {
        return new TraceInterceptionInfo()
                .withId(traceInterception.getId())
                .withCondition(JsonUtils.toDeterministicJson(traceInterception.getCondition()))
                .withSleepDuration(traceInterception.getAction().getSleepDuration())
                .withExceptionMessage(traceInterception.getAction().getExceptionMessage())
                .withSemaphorePermits(traceInterception.getAction().getSemaphorePermits())
                .withSemaphoreKey(getResultSemaphoreKey(traceInterception))
                .withStatus(traceInterception.getStatus());
    }

    private static String getResultSemaphoreKey(TraceInterception interception) {
        Object semaphoreKey = getSemaphoreKey(interception);
        if (semaphoreKey instanceof String) {
            return '"' + semaphoreKey.toString() + '"';
        } else if (interception.getAction().getSemaphorePermits() != null) {
            return semaphoreKey.toString();
        } else {
            return "";
        }
    }
}
