package ru.yandex.direct.internaltools.tools.traceinterceptions.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.traceinterception.model.TraceInterceptionStatus;

public class TraceInterceptionInfo {
    @JsonProperty("Id")
    private long id;
    @JsonProperty("Условие")
    private String condition;
    @JsonProperty("Sleep")
    private Long sleepDuration;
    @JsonProperty("Исключение")
    private String exceptionMessage;
    @JsonProperty("Семафор")
    private Integer semaphorePermits;
    @JsonProperty("Ключ семафора")
    private String semaphoreKey;
    @JsonProperty("Статус")
    private TraceInterceptionStatus status;

    public long getId() {
        return id;
    }

    public TraceInterceptionInfo withId(long id) {
        this.id = id;
        return this;
    }

    public String getCondition() {
        return condition;
    }

    public TraceInterceptionInfo withCondition(String condition) {
        this.condition = condition;
        return this;
    }

    public Long getSleepDuration() {
        return sleepDuration;
    }

    public TraceInterceptionInfo withSleepDuration(Long sleepDuration) {
        this.sleepDuration = sleepDuration;
        return this;
    }

    public String getExceptionMessage() {
        return exceptionMessage;
    }

    public TraceInterceptionInfo withExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
        return this;
    }

    public Integer getSemaphorePermits() {
        return semaphorePermits;
    }

    public TraceInterceptionInfo withSemaphorePermits(Integer semaphorePermits) {
        this.semaphorePermits = semaphorePermits;
        return this;
    }

    public String getSemaphoreKey() {
        return semaphoreKey;
    }

    public TraceInterceptionInfo withSemaphoreKey(String semaphoreKey) {
        this.semaphoreKey = semaphoreKey;
        return this;
    }

    public TraceInterceptionStatus getStatus() {
        return status;
    }

    public TraceInterceptionInfo withStatus(TraceInterceptionStatus status) {
        this.status = status;
        return this;
    }
}
