package ru.yandex.direct.internaltools.tools.traceinterceptions.model;

import javax.annotation.Nullable;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Number;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.traceinterception.model.TraceInterceptionStatus;

public class TraceInterceptionInput extends InternalToolParameter {
    private static final String EMPTY_VALUE = "-";
    private static final String CONDITIONS_DESC = "если не указать, то под фильтр будет попадать любое значение; " +
            "напишите \"" + EMPTY_VALUE + "\", если нужна пустая строка";

    @Input(label = "Сервис", description = CONDITIONS_DESC, required = false)
    private String service;

    @Input(label = "Метод", description = CONDITIONS_DESC, required = false)
    private String method;

    @Input(label = "Функция", description = CONDITIONS_DESC, required = false)
    private String func;

    @Input(label = "Тэги", description = CONDITIONS_DESC, required = false)
    private String tags;

    @Input(label = "Длительность sleep'а (мс)",
            description = "Перед созданием профайла выполняется sleep, значение в миллисекундах",
            required = false)
    @Number(minValue = 0L)
    private Long sleepDuration;

    @Input(label = "Сообщение, с которым надо выкинуть исключение",
            description = "Перед созданием профайла выкидавается исключение, из-за чего участок кода под ним не выполняется",
            required = false)
    private String exceptionMessage;

    @Input(label = "Количество разрешений семафора",
            description = "Позволяет ограничить количество одновременных обращений к сервису или функции, " +
                    "если захвататить семафор не удалось, то выкидывается исключение и участок кода под профайлом не выполняется",
            required = false)
    @Number(maxValue = Integer.MAX_VALUE)
    private Long semaphorePermits;

    @Input(label = "Ключ семафора",
            description = "Можно переопределить ключ семафора (по умолчанию используется ID перехвата).\n" +
                    "Если у разных семафоров совпадает ключ," +
                    "будет использовано максимальное значения количества разрешений",
            required = false)
    private String semaphoreKey;

    @Input(label = "Статус")
    private TraceInterceptionStatus status;

    public String getService() {
        return service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getFunc() {
        return func;
    }

    public void setFunc(String func) {
        this.func = func;
    }

    public String getTags() {
        return tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public Long getSleepDuration() {
        return sleepDuration;
    }

    public void setSleepDuration(Long sleepDuration) {
        this.sleepDuration = sleepDuration;
    }

    public String getExceptionMessage() {
        return exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public Long getSemaphorePermits() {
        return semaphorePermits;
    }

    public void setSemaphorePermits(Long semaphorePermits) {
        this.semaphorePermits = semaphorePermits;
    }

    public String getSemaphoreKey() {
        return semaphoreKey;
    }

    public TraceInterceptionStatus getStatus() {
        return status;
    }

    public void setStatus(TraceInterceptionStatus status) {
        this.status = status;
    }

    public static String convertInputConditionValue(@Nullable String value) {
        return value == null ? null : value.equals(EMPTY_VALUE) ? "" : value;
    }
}
