package ru.yandex.direct.internaltools.tools.traceinterceptions.model;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class TraceInterceptionUpdateActionInput extends InternalToolParameter {
    @Input(label = "ID правила", processors = {TraceInterceptionUpdateSelectProvider.class})
    @Select(preprocessed = true)
    private String id;

    @Input(label = "Тип действия")
    private TraceInterceptionActionType actionType;

    @Input(label = "Новое значение для действия",
            description = "Оставьте поле пустым для выключения действия (не всего правила)",
            required = false)
    private String actionValue;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TraceInterceptionActionType getActionType() {
        return actionType;
    }

    public void setActionType(TraceInterceptionActionType actionType) {
        this.actionType = actionType;
    }

    public String getActionValue() {
        return actionValue;
    }

    public void setActionValue(String actionValue) {
        this.actionValue = actionValue;
    }
}
