package ru.yandex.direct.internaltools.tools.traceinterceptions.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import com.google.common.collect.ImmutableSet;
import org.springframework.stereotype.Component;

import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.input.InternalToolInput;
import ru.yandex.direct.internaltools.core.input.InternalToolInputPreProcessor;
import ru.yandex.direct.traceinterception.entity.traceinterception.service.TraceInterceptionsManagingService;
import ru.yandex.direct.traceinterception.model.TraceInterception;
import ru.yandex.direct.utils.JsonUtils;

import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

@Component
public class TraceInterceptionUpdateSelectProvider implements InternalToolInputPreProcessor<String> {
    public static final Comparator<TraceInterception> SORTING_COMPARATOR =
            Comparator.comparing(TraceInterception::getId).reversed();

    private static final String EMPTY_PLACEHOLDER = "";
    private static final String DELIMITER = "|";

    private TraceInterceptionsManagingService traceInterceptionsManagingService;

    public TraceInterceptionUpdateSelectProvider(TraceInterceptionsManagingService traceInterceptionsManagingService) {
        this.traceInterceptionsManagingService = traceInterceptionsManagingService;
    }

    @Override
    public <T extends InternalToolParameter> InternalToolInput.Builder<T, String> preSend(
            InternalToolInput.Builder<T, String> inputBuilder) {
        List<String> idsWithConditions = traceInterceptionsManagingService.getCached().stream()
                .sorted(SORTING_COMPARATOR)
                .map(x -> x.getId().toString() + DELIMITER + JsonUtils.toDeterministicJson(x.getCondition()) +
                        DELIMITER + x.getStatus().toString())
                .collect(Collectors.toList());

        List<String> displayedValues = new ArrayList<>();
        displayedValues.add(EMPTY_PLACEHOLDER);
        displayedValues.addAll(idsWithConditions);

        return inputBuilder
                .withAllowedValues(displayedValues)
                .addValidator(inSet(ImmutableSet.copyOf(idsWithConditions)))
                .withDefaultValue(null);
    }

    public static Long extractId(String input) {
        return Long.parseLong(input.substring(0, input.indexOf(DELIMITER)));
    }
}
