package ru.yandex.direct.internaltools.tools.trackingphone.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class TelephonyPhoneInfo {

    @JsonProperty("client_phone_id")
    private Long clientPhoneId;

    @JsonProperty("login")
    private String login;

    @JsonProperty("phone")
    private String phone;

    @JsonProperty("redirect_phone")
    private String redirectPhone;

    @JsonProperty("telephony_service_id")
    private String telephonyServiceId;

    @JsonProperty("permalink_id")
    private Long permalinkId;

    @JsonProperty("counter_id")
    private Long counterId;

    @JsonProperty("is_deleted")
    private Boolean isDeleted;

    public Long getClientPhoneId() {
        return clientPhoneId;
    }

    public String getLogin() {
        return login;
    }

    public String getPhone() {
        return phone;
    }

    public String getRedirectPhone() {
        return redirectPhone;
    }

    public String getTelephonyServiceId() {
        return telephonyServiceId;
    }

    public Long getPermalinkId() {
        return permalinkId;
    }

    public Long getCounterId() {
        return counterId;
    }

    public Boolean getIsDeleted() {
        return isDeleted;
    }

    public TelephonyPhoneInfo withClientPhoneId(final Long clientPhoneId) {
        this.clientPhoneId = clientPhoneId;
        return this;
    }

    public TelephonyPhoneInfo withLogin(final String login) {
        this.login = login;
        return this;
    }

    public TelephonyPhoneInfo withPhone(final String phone) {
        this.phone = phone;
        return this;
    }

    public TelephonyPhoneInfo withRedirectPhone(final String redirectPhone) {
        this.redirectPhone = redirectPhone;
        return this;
    }

    public TelephonyPhoneInfo withTelephonyServiceId(final String telephonyServiceId) {
        this.telephonyServiceId = telephonyServiceId;
        return this;
    }

    public TelephonyPhoneInfo withPermalinkId(final Long permalinkId) {
        this.permalinkId = permalinkId;
        return this;
    }

    public TelephonyPhoneInfo withCounterId(final Long counterId) {
        this.counterId = counterId;
        return this;
    }
    public TelephonyPhoneInfo withIsDeleted(final Boolean isDeleted) {
        this.isDeleted = isDeleted;
        return this;
    }

}
