package ru.yandex.direct.internaltools.tools.trackingphone.model;

import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class UnlinkTelephonyToolParameter extends InternalToolParameter {

    public enum Action {
        SHOW_PHONES("Просмотр"),
        UNLINK_PHONE("Отвязать номер");

        private final String description;

        Action(String description) {
            this.description = description;
        }

        @JsonValue
        public String getDescription() {
            return description;
        }
    }

    @Select
    @Input(label = "Действие")
    private UnlinkTelephonyToolParameter.Action action;

    @Text
    @Input(label = "serviceId для удаления")
    private String serviceId;

    public Action getAction() {
        return action;
    }

    public String getServiceId() {
        return serviceId;
    }

}
