package ru.yandex.direct.internaltools.tools.turbo.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class IntToolTurboApp {

    @JsonProperty("ClientId")
    private Long clientId;

    @JsonProperty("Идентификатор турбо-аппа")
    private Long turboAppId;

    @JsonProperty("MetaContent турбо-аппа")
    private String metaContent;

    public Long getClientId() {
        return clientId;
    }

    public IntToolTurboApp withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Long getTurboAppId() {
        return turboAppId;
    }

    public IntToolTurboApp withTurboAppId(Long turboAppId) {
        this.turboAppId = turboAppId;
        return this;
    }

    public String getMetaContent() {
        return metaContent;
    }

    public IntToolTurboApp withMetaContent(String metaContent) {
        this.metaContent = metaContent;
        return this;
    }
}
